<?php
require_once __DIR__ . '/../Shortener.php';
require_once __DIR__ . '/../Http.php';

class Shortest extends Shortener
{
    public static $API_URL = 'https://api.shorte.st/v1/data/url';
    public static $NAME = 'shorte.st';
    private static $debug = false;

    public function shorten($url)
    {
        if (self::$debug) {
            $url = str_replace('localhost', 'localhost.com', $url);
        }
        $http = new Http(self::$API_URL);
        $http->addCurlOption(CURLOPT_CUSTOMREQUEST, 'PUT');
        $http->addCurlOption(CURLOPT_POSTFIELDS, http_build_query(['urlToShorten' => $url]));
        $http->addHeader('public-api-token', $this->API_KEY);
        $http->addHeader('Content-Type', 'application/x-www-form-urlencoded');
        $http->run();
        $data = json_decode($http->response, true);
        if (!empty($data['status']) && $data['status'] == 'ok') {
            if (!empty($data['shortenedUrl'])) {
                return $data['shortenedUrl'];
            }
        }
        return null;
    }
}