<?php
require_once __DIR__ . '/../Shortener.php';
require_once __DIR__ . '/../Http.php';

class Bcvc extends Shortener
{
    public static $API_URL = 'https://bc.vc/api.php';
    public $USER_ID = null;
    public static $NAME = 'bc.vc';
    private static $debug = true;

    public function shorten($url)
    {
        $this->API_KEY = get_option('aiodl_bcvc_api_key');
        $this->USER_ID = get_option('aiodl_bcvc_user_id');
        if (self::$debug) {
            $url = str_replace('localhost', 'example.com', $url);
        }
        $endpoint = 'https://bc.vc/api.php?key=' . $this->API_KEY . '&uid=' . $this->USER_ID . '&url=' . $url;
        $http = new Http($endpoint);
        $http->run();
        if (!empty($http->response) && filter_var($http->response, FILTER_VALIDATE_URL)) {
            return $http->response;
        }
        return null;
    }
}