<?php
require_once __DIR__ . '/../DownloaderCreator.php';

class All_in_One_Video_Downloader_Routes extends WP_REST_Controller
{
    private $enableDebug = false;

    /**
     * Register the routes for the objects of the controller.
     */
    public function register_routes()
    {
        add_action('rest_api_init', function () {
            register_rest_route('aio-dl', '/video-data/', array(
                array(
                    'methods' => 'POST',
                    'callback' => array($this, 'fetchVideo'),
                    'permission_callback' => '__return_true',
                    'args' => array(
                        'url' => array(
                            'default' => '',
                            'validate_callback' => function ($param, $request, $key) {
                                $param = filter_var($param, FILTER_SANITIZE_URL);
                                return filter_var($param, FILTER_VALIDATE_URL);
                            }
                        ),
                        'token' => array(
                            'default' => '',
                            'validate_callback' => function ($param, $request, $key) {
                                return true;
                            }
                        ),
                    ),
                ),
            ));
            $enableRestApi = get_option('aiodl_rest_api') == 'on';
            if ($enableRestApi) {
                register_rest_route('aio-dl', '/api/', array(
                    array(
                        'methods' => 'GET',
                        'callback' => array($this, 'fetchVideo'),
                        'permission_callback' => '__return_true',
                        'args' => array(
                            'url' => array(
                                'default' => '',
                                'validate_callback' => function ($param, $request, $key) {
                                    return filter_var($param, FILTER_VALIDATE_URL);
                                }
                            ),
                            'key' => array(
                                'default' => '',
                                'validate_callback' => function ($param, $request, $key) {
                                    return true;
                                }
                            ),
                        ),
                    ),
                ));
            }
            register_rest_route('aio-dl', '/deactivate/', array(
                    array(
                        'methods' => 'POST',
                        'callback' => array($this, 'deactivateLicense'),
                        'permission_callback' => '__return_true',
                        'args' => array(
                            'token' => array(
                                'default' => '',
                                'validate_callback' => function ($param, $request, $key) {
									return false;
                                }
                            ),
                        ),
                    ),
                )
            );
        });

    }

    /**
     * Get one item from the collection
     *
     * @param WP_REST_Request $request Full data about the request.
     * @return WP_Error|WP_REST_Response
     */
    public function fetchVideo($request)
    {
        //get parameters from request
        $params = $request->get_params();
        $item = array();//do a query, call another class, etc
        $data = $params;
        $downloader = DownloaderCreator::createDownloader($params['url']);
        if ($downloader == null) {
            return new WP_REST_Response(['error' => 'Not supported URL.'], 400);
        }
        $className = strtolower(get_class($downloader));
        $useProxy = get_option('aiodl_proxy_' . $className) == 'on';
        if ($useProxy) {
            $proxyCount = (int)get_option('aiodl_proxy_count');
            if ($proxyCount >= 1) {
                Http::$enableProxy = true;
                $random = rand(0, $proxyCount - 1);
                $proxyType = CURLPROXY_HTTP;
                switch (get_option('aiodl_proxy_type_' . $random)) {
                    case 'http':
                        $proxyType = CURLPROXY_HTTP;
                        break;
                    case 'https':
                        $proxyType = CURLPROXY_HTTPS;
                        break;
                    case 'socks4':
                        $proxyType = CURLPROXY_SOCKS4;
                        break;
                    case 'socks5':
                        $proxyType = CURLPROXY_SOCKS5;
                        break;
                }
                $proxy = [
                    'ip' => get_option('aiodl_proxy_ip_' . $random),
                    'port' => get_option('aiodl_proxy_port_' . $random),
                    'username' => get_option('aiodl_proxy_username_' . $random),
                    'password' => get_option('aiodl_proxy_password_' . $random),
                    'type' => $proxyType
                ];
                Http::$proxy = $proxy;
            }
        }
        $websiteDomain = str_ireplace("www.", "", parse_url(get_site_url(), PHP_URL_HOST));
        $fingerprint = sha1($websiteDomain);
        if ($downloader != null) {
            $downloader->url = $params['url'];
            $downloader->fetch($params['url']);
            if (!$downloader->isValid() && !$this->enableDebug) {
                return new WP_REST_Response(['error' => 'Unknown error occurred.'], 500);
            }
            $downloader->mediaDetails();
            if (get_option('aiodl_enable_latest_downloads') == 'on') {
                $downloader->saveToFile($_SERVER['REMOTE_ADDR']);
            }
            $stats = json_decode(get_option('aiodl_stats'), true);
            if (empty($stats[$className])) {
                $stats[$className] = 1;
            } else {
                $stats[$className]++;
            }
            if (empty($stats['total'])) {
                $stats['total'] = 1;
            } else {
                $stats['total']++;
            }
            update_option('aiodl_stats', json_encode($stats));
            $data = $downloader;
            $_SESSION['result'] = json_decode(json_encode($downloader), true);
        }
        Http::$enableProxy = false;

        //return a response or error based on some conditional
        if (true) {
            if (get_option('aiodl_disable_session') == 'on') {
                $data->sid = sha1($params['url']);
                $cache = new Cache($data->sid, 'json', json_encode($data));
            }
            return new WP_REST_Response($data, 200);
        } else {
            return new WP_Error('code', __('message', 'text-domain'));
        }
    }

    public function deactivateLicense($request)
    {
    }
}