<?php

class Blogger extends Downloader
{
    public function fetch($videoUrl)
    {
        $http = new Http($videoUrl);
        $http->run();
        preg_match_all('/src="https:\/\/www.blogger\.com\/video\.g\?token=(.*?)"/', $http->response, $tokens);
        $this->title = Helpers::getStringBetween($http->response, '<title>', '</title>');
        $this->source = 'blogger';
        $itags = [5 => ['extension' => 'flv', 'video' => ['width' => 400, 'height' => 240,],], 6 => ['extension' => 'flv', 'video' => ['width' => 450, 'height' => 270,],], 13 => ['extension' => '3gp',], 17 => ['extension' => '3gp', 'video' => ['width' => 176, 'height' => 144,],], 18 => ['extension' => 'mp4', 'video' => ['width' => 640, 'height' => 360,],], 22 => ['extension' => 'mp4', 'video' => ['width' => 1280, 'height' => 720,],], 34 => ['extension' => 'flv', 'video' => ['width' => 640, 'height' => 360,],], 35 => ['extension' => 'flv', 'video' => ['width' => 854, 'height' => 480,],], 36 => ['extension' => '3gp', 'video' => ['width' => 320, 'height' => 240,],], 37 => ['extension' => 'mp4', 'video' => ['width' => 1920, 'height' => 1080,],], 38 => ['extension' => 'mp4', 'video' => ['width' => 4096, 'height' => 3072,],], 43 => ['extension' => 'webm', 'video' => ['width' => 640, 'height' => 360,],], 44 => ['extension' => 'webm', 'dash' => false, 'video' => ['width' => 854, 'height' => 480,],], 45 => ['extension' => 'webm', 'video' => ['width' => 1280, 'height' => 720,],], 46 => ['extension' => 'webm', 'video' => ['width' => 1920, 'height' => 1080,],], 59 => ['extension' => 'mp4', 'video' => ['width' => 854, 'height' => 480,],], 78 => ['extension' => 'mp4', 'video' => ['width' => 854, 'height' => 480,],], 82 => ['extension' => 'mp4', 'video' => ['3d' => true, 'width' => 640, 'height' => 360,],], 83 => ['extension' => 'mp4', 'video' => ['3d' => true, 'width' => 854, 'height' => 480,],], 84 => ['extension' => 'mp4', 'video' => ['3d' => true, 'width' => 1280, 'height' => 720,],], 85 => ['extension' => 'mp4', 'video' => ['3d' => true, 'width' => 1920, 'height' => 1080,],], 100 => ['extension' => 'webm', 'video' => ['3d' => true, 'width' => 640, 'height' => 360,],], 101 => ['extension' => 'webm', 'video' => ['3d' => true, 'width' => 854, 'height' => 480,],], 102 => ['extension' => 'webm', 'video' => ['3d' => true, 'width' => 1280, 'height' => 720,],], 133 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 426, 'height' => 240,],], 134 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 640, 'height' => 360,],], 135 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 854, 'height' => 480,],], 136 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 1280, 'height' => 720,],], 137 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 1920, 'height' => 1080,],], 138 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 4096, 'height' => 2304,],], 394 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 256, 'height' => 144,],], 395 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 426, 'height' => 240,],], 396 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 640, 'height' => 360,],], 397 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 854, 'height' => 480,],], 398 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 1280, 'height' => 720,],], 399 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 1920, 'height' => 1080,],], 139 => ['extension' => 'm4a', 'dash' => 'audio', 'audio' => ['bitrate' => 48000, 'frequency' => 22050,],], 140 => ['extension' => 'm4a', 'dash' => 'audio', 'audio' => ['bitrate' => 128000, 'frequency' => 44100,],], 141 => ['extension' => 'm4a', 'dash' => 'audio', 'audio' => ['bitrate' => 256000, 'frequency' => 44100,],], 160 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 256, 'height' => 144,],], 167 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 640, 'height' => 360,],], 168 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 854, 'height' => 480,],], 169 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 1280, 'height' => 720,],], 170 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 1920, 'height' => 1080,],], 171 => ['extension' => 'webm', 'dash' => 'audio', 'audio' => ['bitrate' => 128000, 'frequency' => 44100,],], 172 => ['extension' => 'webm', 'dash' => 'audio', 'audio' => ['bitrate' => 192000, 'frequency' => 44100,],], 218 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 854, 'height' => 480,],], 219 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 854, 'height' => 480,],], 242 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 427, 'height' => 240,],], 243 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 640, 'height' => 360,],], 244 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 854, 'height' => 480,],], 245 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 854, 'height' => 480,],], 246 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 854, 'height' => 480,],], 247 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 1280, 'height' => 720,],], 248 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 1920, 'height' => 1080,],], 249 => ['extension' => 'webm', 'dash' => 'audio', 'audio' => ['bitrate' => 50000, 'frequency' => 48000,],], 250 => ['extension' => 'webm', 'dash' => 'audio', 'audio' => ['bitrate' => 65000, 'frequency' => 48000,],], 251 => ['extension' => 'webm', 'dash' => 'audio', 'audio' => ['bitrate' => 158000, 'frequency' => 48000,],], 264 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 2560, 'height' => 1440,],], 266 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 3840, 'height' => 2160,],], 271 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['3d' => false, 'width' => 2560, 'height' => 1440,],], 272 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 3840, 'height' => 2160,],], 278 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 256, 'height' => 144,],], 298 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 1280, 'height' => 720,],], 299 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 1920, 'height' => 1080,],], 302 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 1280, 'height' => 720,],], 303 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 1920, 'height' => 1080,],], 308 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 2560, 'height' => 1440,],], 313 => ['extension' => 'webm', 'dash' => 'video', 'video' => ['width' => 3840, 'height' => 2026,],], 400 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 2560, 'height' => 1440,],], 401 => ['extension' => 'mp4', 'dash' => 'video', 'video' => ['width' => 3840, 'height' => 2160,],],];
        if (!empty($tokens[1])) {
            foreach ($tokens[1] as $iframe_token) {
                $iframeUrl = 'https://www.blogger.com/video.g?token=' . $iframe_token;
                $iframePage = new Http($iframeUrl);
                $iframePage->run();
                preg_match_all('/var VIDEO_CONFIG = (.*)/', $iframePage->response, $videoData);
                if (!empty(($videoData[1][0]) ?? '')) {
                    $videoData = json_decode($videoData[1][0], true);
                    if (empty($this->thumbnail)) {
                        $this->thumbnail = $videoData['thumbnail'];
                    }
                    foreach ($videoData['streams'] as $stream) {
                        array_push($this->medias, new Media($stream['play_url'], $itags[$stream['format_id']]['video']['height'] . 'p', $itags[$stream['format_id']]['extension'], true, true));
                    }
                }
            }
            usort($this->medias, array('Helpers', 'sortByQuality'));
        }
    }
}