var siteUrl = WPURLS.siteurl;
var autoFetch = false;
var executed = false;
let elm;

document.getElementById("downloadBtn").addEventListener("click", clickDownload);
window.addEventListener("hashchange", function () {
    url();
}, false);
url();

function clickDownload(e) {
    let url = document.getElementById("url").value;
    let token = document.getElementById("token").value;
    if (!isEmpty(url) && isValidURL(url)) {
        executed = true;
        hideAlert();
        let headers = new Headers();
        headers.append("Content-Type", "application/x-www-form-urlencoded");
        let urlencoded = new URLSearchParams();
        urlencoded.append("url", url);
        urlencoded.append("token", token);
        let requestOptions = {
            method: 'POST',
            headers: headers,
            body: urlencoded,
            redirect: 'follow'
        };
        showLoader();
        removeHash();
        window.location.replace("#url=" + url);
        fetch(siteUrl + "/wp-json/aio-dl/video-data/", requestOptions)
            .then(response => response.text())
            .then(result => showResult(result))
            .catch(error => showAlert(error));
    } else {
        showAlert("Please enter a valid URL.");
    }
    e.preventDefault();
}

var input = document.getElementById("url");
input.addEventListener("keyup", function (event) {
    if (event.keyCode === 13) {
        clickDownload();
        event.preventDefault();
    }
});


function url() {
    if (window.location.href.indexOf("#url=") > -1 && executed === false) {
        let url = window.location.href.match(new RegExp("#url=(.+)", ""))[1];
        let token = document.getElementById("token").value;
        document.getElementById("url").value = url;
        document.getElementById("header").scrollIntoView();
        if (autoFetch && token !== "" && url !== "" && !executed) {
            clickDownload();
            executed = true;
        }
    }
}

function isValidURL(url) {
    if (!elm) {
        elm = document.createElement('input');
        elm.setAttribute('type', 'url');
    }
    elm.value = url;
    return elm.validity.valid;
}

function isEmpty(str) {
    return (!str || str.length === 0);
}

function showLoader() {
    document.getElementById("url").style.display = "none";
    document.getElementById("downloadBtn").style.display = "none";
    document.getElementById("pasteBtn").style.display = "none";
    let loader = document.createElement("img");
    loader.src = siteUrl + "/wp-content/themes/aiodl-default/assets/loader.svg";
    loader.className = "img-fluid w-25 mx-auto";
    loader.id = "loader";
    document.getElementById("download-form").appendChild(loader);
}

function hideLoader() {
    document.getElementById("url").style.display = "";
    document.getElementById("downloadBtn").style.display = "";
    document.getElementById("pasteBtn").style.display = "";
    document.getElementById("loader").remove();
}

function showAlert(message) {
    let alertDiv = document.getElementById("alert");
    alertDiv.innerHTML = message;
    alertDiv.style.display = "";
    setTimeout(hideAlert, 5000);
}

function hideAlert() {
    let alertDiv = document.getElementById("alert");
    alertDiv.innerHTML = "";
    alertDiv.style.display = "none";
}

function removeHash() {
    history.pushState("", document.title, window.location.pathname
        + window.location.search);
}

function showResult(result) {
    hideLoader();
    result = JSON.parse(result);
    let template = '<div class="container"> <div class="row mb-0"> <div class="col-12 mb-10 mb-lg-0"> <h2 class="mt-8 mb-0">{{title}} <small class="text-muted" id="videoDuration">{{duration}}</small></h2> <div class="row"> <div class="col-md-4 col-sm-12 mt-4"> <img class="position-relative img-fluid rounded" style="object-fit: cover;" src="{{thumbnail}}" alt="{{title}}" title="{{title}}"> </div><div class="col-md-8 col-sm-12 mt-4">{{links}}</div> </div> </div> <div class="row mb-n6 py-6 d-flex align-items-start text-center"> <div id="share-buttons"> <p class="lead share-text">Share</p> <a title="Facebook" href="{{facebook_share_link}}" class="btn btn-social btn-fill btn-facebook mx-1" target="_blank">Facebook</a><a title="Twitter" href="{{twitter_share_link}}" class="btn btn-social btn-fill btn-twitter mx-1" target="_blank">Twitter</a><a title="Whatsapp" href="{{whatsapp_share_link}}" class="btn btn-social btn-fill btn-whatsapp mx-1" target="_blank">Whatsapp</a><a title="Pinterest" href="{{pinterest_share_link}}" class="btn btn-social btn-fill btn-pinterest mx-1" target="_blank">Pinterest</a><a title="Tumblr" href="{{tumblr_share_link}}" class="btn btn-social btn-fill btn-tumblr mx-1" target="_blank">Tumblr</a><a title="Reddit" href="{{reddit_share_link}}" class="btn btn-social btn-fill btn-reddit mx-1" target="_blank">Reddit</a><a title="QR Code" href="{{qr_share_link}}" class="btn btn-social btn-fill btn-qr mx-1" target="_blank">QR Code</a></div></div></div></div>'
    let buttons = "";
    let buttonTemplate1 = '<a href="{{url}}" class="btn btn-success btn-sq btn-dl text-uppercase mx-1 my-1" target="_blank"><strong>{{quality}}</strong><br>{{icon}}{{type}}<br>({{size}})</a>';
    let buttonTemplate2 = '<a href="{{url}}" class="btn btn-danger btn-sq btn-dl text-uppercase  mx-1 my-1" target="_blank"><strong>{{quality}}</strong><br>{{icon}}{{type}}<br>({{size}})</a>';
    let buttonTemplate3 = '<a href="{{url}}" class="btn btn-info btn-sq btn-dl text-uppercase mx-1 my-1" target="_blank"><strong>{{quality}}</strong><br>{{icon}}{{type}}<br>({{size}})</a>';
    let audioIcon = '<svg xmlns="http://www.w3.org/2000/svg" height="1rem" fill="white" viewBox="0 0 415.963 415.963"><path d="M328.712 264.539c12.928-21.632 21.504-48.992 23.168-76.064 1.056-17.376-2.816-35.616-11.2-52.768-13.152-26.944-35.744-42.08-57.568-56.704-16.288-10.912-31.68-21.216-42.56-35.936l-1.952-2.624c-6.432-8.64-13.696-18.432-14.848-26.656-1.152-8.32-8.704-14.24-16.96-13.76a15.957 15.957 0 00-14.88 15.936v285.12c-13.408-8.128-29.92-13.12-48-13.12-44.096 0-80 28.704-80 64s35.904 64 80 64 80-28.704 80-64V165.467c24.032 9.184 63.36 32.576 74.176 87.2-2.016 2.976-3.936 6.176-6.176 8.736-5.856 6.624-5.216 16.736 1.44 22.56 6.592 5.888 16.704 5.184 22.56-1.44 4.288-4.864 8.096-10.56 11.744-16.512.384-.448.737-.928 1.056-1.472z"/></svg> ';
    let videoIcon = '<svg xmlns="http://www.w3.org/2000/svg" height="1rem" fill="white" viewBox="0 0 467.968 467.968"><path d="M264.704 96.512H51.2c-28.16 0-51.2 23.04-51.2 51.2v172.544c0 28.16 23.04 51.2 51.2 51.2h213.504c28.16 0 51.2-23.04 51.2-51.2V147.712c0-28.672-23.04-51.2-51.2-51.2zM430.08 124.672c-3.072.512-6.144 2.048-8.704 3.584l-79.872 46.08V293.12l80.384 46.08c14.848 8.704 33.28 3.584 41.984-11.264 2.56-4.608 4.096-9.728 4.096-15.36V154.368c0-18.944-17.92-34.304-37.888-29.696z"/></svg> ';
    let imageIcon = '<svg xmlns="http://www.w3.org/2000/svg" height="1rem" fill="white" viewBox="0 0 550.801 550.8"><path d="M515.828 61.201H34.972C15.659 61.201 0 76.859 0 96.172V454.63c0 19.312 15.659 34.97 34.972 34.97h480.856c19.314 0 34.973-15.658 34.973-34.971V96.172c0-19.313-15.658-34.971-34.973-34.971zm0 34.971V350.51l-68.92-62.66c-10.359-9.416-26.289-9.04-36.186.866l-69.752 69.741-137.532-164.278c-10.396-12.415-29.438-12.537-39.99-.271L34.972 343.219V96.172h480.856zm-148.627 91.8c0-26.561 21.523-48.086 48.084-48.086 26.562 0 48.086 21.525 48.086 48.086s-21.523 48.085-48.086 48.085c-26.56.001-48.084-21.524-48.084-48.085z"/></svg> ';
    let dashIcon = '<svg xmlns="http://www.w3.org/2000/svg" height="1rem" fill="white" viewBox="0 0 448.075 448.075"><path d="M352.021 16.075c0-6.08-3.52-11.84-8.96-14.4-5.76-2.88-12.16-1.92-16.96 1.92l-141.76 112.96 167.68 167.68V16.075zM443.349 420.747l-416-416c-6.24-6.24-16.384-6.24-22.624 0s-6.24 16.384 0 22.624l100.672 100.704h-9.376c-9.92 0-18.56 4.48-24.32 11.52-4.8 5.44-7.68 12.8-7.68 20.48v128c0 17.6 14.4 32 32 32h74.24l155.84 124.48c2.88 2.24 6.4 3.52 9.92 3.52 2.24 0 4.8-.64 7.04-1.6 5.44-2.56 8.96-8.32 8.96-14.4v-57.376l68.672 68.672c3.136 3.136 7.232 4.704 11.328 4.704s8.192-1.568 11.328-4.672c6.24-6.272 6.24-16.384 0-22.656z"/></svg> ';
    let i = 0;
    if (typeof result.medias === "undefined") {
        showAlert("No media found.");
        return;
    }
    result.medias.forEach(function (media) {
        if (media.url !== null) {
            let button;
            let icon;
            if (media.extension === "jpg" || (media.videoAvailable === true && media.audioAvailable === true)) {
                button = buttonTemplate1;
            } else if (media.quality.includes("kbps")) {
                button = buttonTemplate2;
            } else {
                button = buttonTemplate3;
            }
            if (media.extension === "jpg") {
                icon = imageIcon;
            } else if (media.videoAvailable === true && media.audioAvailable === false) {
                icon = dashIcon;
            } else if (media.quality.includes("kbps")) {
                icon = audioIcon;
            } else {
                icon = videoIcon;
            }
            button = button.replace(new RegExp("{{quality}}", "g"), media.quality);
            button = button.replace(new RegExp("{{type}}", "g"), media.extension);
            button = button.replace(new RegExp("{{icon}}", "g"), icon);
            button = button.replace(new RegExp("{{size}}", "g"), media.formattedSize);
            button = button.replace(new RegExp("{{url}}", "g"), siteUrl + "/wp-content/plugins/aio-video-downloader/download.php?source=" + result.source + "&media=" + btoa(i));
            buttons = buttons.concat(button);
            i++;
        }
    });
    template = template.replace(new RegExp("{{title}}", "g"), result.title);
    template = template.replace(new RegExp("{{thumbnail}}", "g"), result.thumbnail);
    template = template.replace(new RegExp("{{duration}}", "g"), result.duration);
    template = template.replace(new RegExp("{{links}}", "g"), buttons);
    var sharingUrl = window.location.href.replace(new RegExp("#url=", "g"), "?u=");
    template = template.replace(new RegExp("{{facebook_share_link}}", "g"), encodeURI("https://www.facebook.com/sharer.php?u=" + sharingUrl));
    template = template.replace(new RegExp("{{twitter_share_link}}", "g"), encodeURI("https://twitter.com/intent/tweet?url=" + sharingUrl + "&text=Download " + result.title));
    template = template.replace(new RegExp("{{whatsapp_share_link}}", "g"), encodeURI("whatsapp://send?text=Download " + result.title + " " + sharingUrl));
    template = template.replace(new RegExp("{{pinterest_share_link}}", "g"), encodeURI("http://pinterest.com/pin/create/link/?url=" + sharingUrl));
    template = template.replace(new RegExp("{{tumblr_share_link}}", "g"), encodeURI("https://www.tumblr.com/widgets/share/tool?canonicalUrl=" + sharingUrl + "&title=" + result.title));
    template = template.replace(new RegExp("{{reddit_share_link}}", "g"), encodeURI("https://reddit.com/submit?url=" + sharingUrl + "&title=" + result.title));
    template = template.replace(new RegExp("{{qr_share_link}}", "g"), encodeURI("https://chart.googleapis.com/chart?cht=qr&chs=300x300&chl=" + sharingUrl));
    document.getElementById("result").innerHTML = template;
    if (result.duration === null) {
        document.getElementById("videoDuration").remove();
    }
    let resultDiv = document.getElementById("result");
    resultDiv.style.display = "";
    document.getElementById("ad-area-2").scrollIntoView();
}

document.getElementById("pasteBtn").addEventListener("click", (e) => {
    let pasteBtn = document.getElementById("pasteBtn");
    let input = document.getElementById("url")
    if (pasteBtn.innerHTML === 'Clear') {
        input.value = "";
        pasteBtn.innerHTML = 'Paste from clipboard';
    } else {
        navigator.clipboard.readText().then(clipText =>
                input.value = clipText,
            pasteBtn.innerHTML = 'Clear');
    }
});